﻿# MSC - DiSTIC - UNIGE
# MODIFIÉ LE 17.12.2024 

<# 
.SYNOPSIS 
    Ajouter/Supprimer l'imprimante UNIQUE-CARD_SYSTEM-ETU
.DESCRIPTION 

.NOTES 
    GUI Version 1.0.1
.EXAMPLE 
    ./UNIQUE-CARD_SYSTEM-ETU-AsAdmin.PS1 "Add" or "Remove"
.OUTPUTS 
#>

param
    (
        [Parameter(Mandatory=$true, Position=0)]
        $Param
    )

# Teste si le script est lance en admin sinon le relance en admin
$currentUser = New-Object Security.Principal.WindowsPrincipal $([Security.Principal.WindowsIdentity]::GetCurrent())
$testadmin = $currentUser.IsInRole([Security.Principal.WindowsBuiltinRole]::Administrator)
if ($testadmin -eq $false) 
{
    Start-Process powershell.exe -Verb RunAs -ArgumentList ('-noprofile -file "{0} $Param" -elevated' -f ($myinvocation.MyCommand.Definition)) 
}

#Location
$RepLocation=get-location
[string]$RepCourantPath=$RepLocation.Path+"\PSScript"

Function Add_Printer_UNIQUE
{
    try {
        $PrinterName=get-printer -Name "UNIQUE-CARD_SYSTEM-ETU" -ErrorAction SilentlyContinue
    }
    catch {}
    if ($null -eq $PrinterName)
        {

        try {
            $OS = Get-WmiObject -class Win32_OperatingSystem -ErrorAction SilentlyContinue | Select-Object MUILanguages, OSArchitecture
        } 
        catch {}
               
        #Windows en français : installation du pilote en français
        $OSLangMU=$OS.MUILanguages -replace "-"," "
        $OSLangMU=$OSLangMU -split " "
        if ($OSLangMU -contains "fr") 
        {
            if (($OS.OSArchitecture -eq "32 bits") -or ($OS.OSArchitecture -eq "32-bit"))
                            {
                #Pilote d'impression 32bits
                $InstallDriver = {pnputil -i -a "$RepCourantPath\PS_Driver_V3002_32_64_FR_01\32bit\Driver\CNS30F.inf"}
                $InstallPrinter = {cmd /c 'rundll32 printui.dll,PrintUIEntry /b UNIQUE-CARD_SYSTEM-ETU /x /n UNIQUE-CARD_SYSTEM-ETU /if /F "$RepCourantPath"\PS_Driver_V3002_32_64_FR_01\32bit\Driver\CNS30F.inf /r "https://printetu.unige.ch/printers/CARD_SYSTEM-ETU/.printer" /m "Canon iR-ADV C7580/7570 PS3" /q'}
            } 
            else 
            {
                #Pilote 64bits     
                $InstallDriver = {pnputil -i -a "$RepCourantPath\PS_Driver_V3002_32_64_FR_01\x64\Driver\CNS30FA64.INF"}
                $InstallPrinter = {cmd /c 'rundll32 printui.dll,PrintUIEntry /b UNIQUE-CARD_SYSTEM-ETU /x /n UNIQUE-CARD_SYSTEM-ETU /if /F "$RepCourantPath"\PS_Driver_V3002_32_64_FR_01\x64\Driver\CNS30FA64.inf /r "https://printetu.unige.ch/printers/CARD_SYSTEM-ETU/.printer" /m "Canon iR-ADV C7580/7570 PS3" /q'}     
            }
        }
        else 
        #Autre langue : installation du pilote en anglais
        {
            if (($OS.OSArchitecture -eq "32 bits") -or ($OS.OSArchitecture -eq "32-bit"))
            {
                #Pilote d'impression 32bits
                $InstallDriver = {pnputil -i -a "$RepCourantPath\PS_Driver_V3002_32_64_EN_00\32bit\Driver\CNS30K.inf"}
                $InstallPrinter = {cmd /c 'rundll32 printui.dll,PrintUIEntry /b UNIQUE-CARD_SYSTEM-ETU /x /n UNIQUE-CARD_SYSTEM-ETU /if /F "$RepCourantPath"\PS_Driver_V3002_32_64_EN_00\32bit\Driver\CNS30K.inf /r "https://printetu.unige.ch/printers/CARD_SYSTEM-ETU/.printer" /m "Canon iR-ADV C7580/7570 PS3" /q'}
            } 
            else 
            {
                #Pilote 64bits
                $InstallDriver = {pnputil -i -a "$RepCourantPath\PS_Driver_V3002_32_64_EN_00\x64\Driver\CNS30KA64.inf"}
                #$InstallPrinter = {cmd /c 'rundll32 printui.dll,PrintUIEntry /b\\https://printec.unige.ch\CARD_SYSTEM /x /n UNIQUE-CARD_SYSTEM /if /F $RepCourantPath\PS_Driver_V3002_32_64_EN_00\x64\Driver\CNS30KA64.inf /r https://printec.unige.ch/printers/CARD_SYSTEM/.printer /m "Canon iR-ADV C7580/7570 PS3" /q'}
                $InstallPrinter = {cmd /c 'rundll32 printui.dll,PrintUIEntry /b UNIQUE-CARD_SYSTEM-ETU /x /n UNIQUE-CARD_SYSTEM-ETU /if /F $RepCourantPath\PS_Driver_V3002_32_64_EN_00\x64\Driver\CNS30KA64.inf /r https://printetu.unige.ch/printers/CARD_SYSTEM-ETU/.printer /m "Canon iR-ADV C7580/7570 PS3" /q'}
          
            }
        }

        #Installation du pilote
        try 
        {
            Invoke-Command -ScriptBlock $InstallDriver -ErrorAction SilentlyContinue
            start-Sleep -Seconds 3
        } 
        catch {}

        #Installation de l'imprimante
        try {
            Invoke-Command -ScriptBlock $InstallPrinter -ErrorAction SilentlyContinue
            Start-Sleep -Seconds 3
        } 
        catch {}
    }
}

Function Remove_Device_UNIQUE {
[OutputType([bool])]
    param
    (
    )
    Try{
        $null=Invoke-Command -ScriptBlock {pnputil /remove-device (Get-PnpDevice | Where-Object{$_.Name -eq "UNIQUE-CARD_SYSTEM-ETU"}).InstanceId} -ErrorAction SilentlyContinue       
        return $true
    }
    Catch {
        return $false
    }
}

If ($Param -eq "Add")
{
    Add_Printer_UNIQUE
}

If ($Param -eq "Remove")
{
    Remove_Device_UNIQUE
}
