﻿
<# 
.CONTEXTE
    Un utilisateur du domaine peut vérifier ses accès à une imprimante qui est gérée par l'un des serveurs d'impression
    Prérequis : l'ordinateur doit être joins au domaine ISIS et se loger avec son compte ISIS
.DESCRIPTION 
    1. Rechercher le serveur d'impression pour une imprimante spécifiée
    2. Obtenir les permissions SDDL de l'imprimante (Security Descriptor Definition Language) 
    3. Ajout des ACE (Access Control Entries) de l'imprimante dans un customobject
    4. Convertir les groupes SIDs d'appartenance l'imprimante en groupe AD
    5. Convertir les groupes SIDs d'appartenance de l'utilisateur courrant en groupe AD
    6. Comparer les groupes AD d'appartenance de l'imprimante et de l'utilisateur, ajout des reslutats dans un customobject
    
.NOTE
    Version 0.1.0  
    MSC - GSENT - DISTIC  
.EXEMPLE
    ./PrinterPermission.ps1     
.SORTIE
    Affiche les groupes AD de l'imprimante qui inclue l'utilisateur courrant (login AD)
#>

# Import the necessary .NET assemblies for GUI components
Add-Type -AssemblyName System.Windows.Forms
[System.Windows.Forms.Application]::EnableVisualStyles()

#Functions
function cancel_Button {
    $form.close()
}

function next_button {
    #$Installer.PrinterShareName=$TEXTBOX0.Text
    $PrinterShareName=$Installer.PrinterShareName
    $Domain=$Installer.Domain
    if (($Domain -eq "ISIS") -and ($PrinterShareName -ne "")) 
    { 
        $TEXTBOX1.SelectedText+="Recherche du serveur d'impression pour l'imprimante $PrinterShareName..."
        $Form.Refresh()
        
        #Rechercher le serveur d'impression pour une imprimante
        $Servers = @("Wuniprint1","Wuniprint2","Wuniprint3","Wuniprint5","Wuniprint6")
        $PrinterServer=foreach ($Server in $Servers) {
            try {
                    (Get-Printer -ComputerName $Server -Name "$PrinterShareName" -ErrorAction SilentlyContinue).ComputerName   
                } 
                catch {}
        }
        $Installer.Printserver=$PrinterServer
        [string]$PrintServer=$Installer.Printserver
        $PrintServer=$PrintServer.Replace(' ','')
        $Installer.PathPrintSMB="\\$PrintServer.isis.unige.ch\$PrinterShareName"
        $PathPrintSMB=$Installer.PathPrintSMB
        if (($PrintServer -eq "") -or ($Printserver -eq $null))
        {
            $TEXTBOX1.SelectedText+="[Echec]`r`n"
            $instButton.Enabled = $false
            $nextButton.Enabled = $false 
            $Form.Refresh()
        }
        else
        {
            #$PrintServer=$Installer.Printserver
            #$PrinterShareName=$Installer.PrinterShareName
            #$PathPrintSMB=$Installer.PathPrintSMB
            $TEXTBOX1.SelectedText+="[Succès]`r`n"
            $TEXTBOX1.SelectedText+= "[Info] L'UNC de l'imprimante est $PathPrintSMB`r`n"
            $TEXTBOX1.SelectedText+= "Vérification des authoristions d'accès pour l'imprimante '$PrinterShareName'. Veuillez patienter environ une à deux minutes..."
            $Form.Refresh()
            #Obtenir les permissions SDDL d'une imprimante (Security Descriptor Definition Language)
            $printerperms = try { 
                    (Get-Printer -ComputerName $Printserver -Name "$PrinterShareName" -Full -ErrorAction SilentlyContinue).PermissionSDDL
                    }
                catch {}
            if ($printerperms -eq "")
            {
                $TEXTBOX1.SelectedText+="[Erreur] Les propriétés ACE (Access Control Entries) ne sont pas accessible."
                $Form.Refresh() 
                $instButton.Enabled = $false
                $nextButton.Enabled = $false    
            }
            else
            {
                #$TEXTBOX1.SelectedText+= "[Succès]`r`n"
                $Form.Refresh()
                
                #Selection des groupes autorisés "ACCESS"
                $SDDLs=$printerperms.split('(')
                $PrinterACE=foreach ($SDDL in $SDDLs){
                    $ACE=$SDDL.split(";)")
                    if ($ACE.GetValue(0) -eq "A") {
                            [pscustomobject]@{
                                Type=$ACE.GetValue(0)
                                Flags=$ACE.GetValue(1)
                                Right=$ACE.GetValue(2)
                                GUID=$ACE.GetValue(3)
                                InheritGUID=$ACE.GetValue(4)
                                SID=$ACE.GetValue(5)
                            }   
                    }
                }
                #Sélection des groupes avec les SIDs "S-1"
                #$PrinterGroupsSID=$PrinterACE.SID.ForEach({$_.Substring($_.IndexOf("S-1"))}) 
                $PrinterGroupsSID=ForEach ($PrintACE in $PrinterACE.SID) {
                    if ($PrintACE -cmatch "S-1") {
                        $PrintACE
                    } 
                }
                
                #Convertir en compte AD, les groupes SIDs d'appartenance l'imprimante
                $PrinterGroupsAD=foreach ($PrinterSID in $PrinterGroupsSID) {
                        $objSID = try {
                            New-Object System.Security.Principal.SecurityIdentifier("$PrinterSID") -ErrorAction SilentlyContinue
                            } 
                            catch {}
                        $objUser = try {
                            $objSID.Translate([System.Security.Principal.NTAccount])
                            } 
                            catch {}
                        $objUser.Value
                }
                
                #Convertir en compte AD, les groupes SIDs d'appartenance de l'utilisateur courrant
                $currentIdentity = [Security.Principal.WindowsIdentity]::GetCurrent()
                $currentPrincipal = try {
                    New-Object System.Security.Principal.WindowsPrincipal($currentIdentity) -ErrorAction SilentlyContinue
                    }
                    catch {}
                $UserGroupsSID=$currentPrincipal.Identities.groups.Value
                $UserGroupsAD=foreach ($UserGroupSID in $UserGroupsSID) 
                    {
                    $objSID = try {
                        New-Object System.Security.Principal.SecurityIdentifier("$UserGroupSID")
                        }
                        catch {}
                        $objUser=try {
                            $objSID.Translate( [System.Security.Principal.NTAccount])
                            }
                            catch {}
                        $objUser.Value
                    }

                #Comparer les groupes AD de l'imprimante et de l'utilisateur, ajout des résultats dans un customobject
                [string]$include=$null
                $compare=$null
                $Compare=foreach ($PrinterGroupAD in $PrinterGroupsAD) {
                    if ($UserGroupsAD -contains $PrinterGroupAD) {
                        $Include=$true
                    } 
                    else {
                        $Include=$false
                    }
                    [pscustomobject]@{
                        PrinterGroupAccess = "$PrinterGroupAD"
                        UserIncludToPrint = $Include
                        UserName = $env:username
                        PrinterName = $PrinterShareName
                        PrintServerName = $PrintServer
                    }

                }
                #$Username=$Compare[0].username.ToString()
                $compare = $compare | where-object {$_.Printergroupaccess -ne $null}
                $GroupeAccessPrint = $compare |  Where-Object {$_.userincludtoprint -like "$true" -and $_.Printergroupaccess -ne $null}
                
                [string]$RightToPrint=$GroupeAccessPrint.PrinterGroupAccess
                if ($RightToPrint -eq "") {
                    $Username=$env:username
                    $instButton.Enabled = $false
                    $nextButton.Enabled = $false
                    $TEXTBOX1.SelectedText+= "[Echec]`r`n"
                    $TEXTBOX1.SelectedText += "• L'utilisateur '$username' n'est pas encore ajouter au groupe d'accès AD de l'imprimante '$PrinterShareName'. Demander à votre correspondant informatique d'ajouter votre compte utilisateur ISIS dans le groupe d'accès AD de l'imprimante." 
                    $Form.Refresh()  
                } 
                else { 
                    $Username=$GroupeAccessPrint.UserName
                    $instButton.Enabled = $true
                    $nextButton.Enabled = $false
                    $TEXTBOX1.SelectedText+= "[Succès]`r`n"
                    $TEXTBOX1.SelectedText += "[Info] L'utilisateur '$username' appartient au groupe d'accès : $RightToPrint`.`r`n" 
                    $TEXTBOX1.SelectedText += "• Vous avez les droits d'installation et d'impression sur l'imprimante partagée '$PrinterShareName'`r`n"
                    $TEXTBOX1.SelectedText += "• Cliquer sur le bouton 'Installer' pour installer l'imprimante`r`n"
                    $Form.Refresh() 
                }
            }
        }    

    }
    else
    {
        if (($Installer.PrinterShareName -eq "")) {
            $TEXTBOX1.SelectedText+="[Échec] L'imprimante n'est pas spécifiée.`r`n"
            $Form.Refresh()
        }
        elseif (($Script:Domain -eq "ISIS.UNIGE.CH")) {
            $TEXTBOX1.SelectedText+="[Échec] L'ordinateur ne fait pas partie du domine ISIS.`r`n"
            $Form.Refresh()
        }
    }

}

function inst_button {
    $PrintServer=$Installer.Printserver
    $PrinterShareName=$Installer.PrinterShareName
    $PathPrintSMB=$Installer.PathPrintSMB
    $TEXTBOX1.SelectedText += "Installation de l'imprimante '$PrinterShareName'..."
    $Form.Refresh()
    #Ajout de l'imprimante SMB
    $ArgList = @{ArgumentList ="Add-Printer -ConnectionName $PathPrintSMB"}
    #$ArgList = @{ArgumentList = "New-ItemProperty -Path 'HKCU:\Software\Microsoft\Windows NT\CurrentVersion\Windows' -Name 'LegacyDefaultPrinterMode' -Value 1 -Force -ErrorAction Stop"}
    try {
        Start-Process powershell.exe -Verb RunAs -ArgumentList $ArgList.ArgumentList -Wait -WindowStyle Hidden -ErrorAction Stop
        #Start-Process $env:ComSpec -ArgumentList $ArgList.ArgumentList -Wait -WindowStyle Hidden -ErrorAction Stop
        $TEXTBOX1.SelectedText += "[Succès]`r`n"
        $cancelButton.Text="Terminer"
        $nextButton.Enabled=$false
        $instButton.Enabled=$false
        $Form.Refresh()
    } 
    catch {
        $TEXTBOX1.SelectedText += "[Échec]`r`n"
        $cancelButton.Text="Terminer"
        $nextButton.Enabled=$false
        $instButton.Enabled=$false
        $Form.Refresh()
    }    
    Start-Sleep 5    
    $DeviceInstanceID=(Get-PnpDevice | Where-Object{$_.Name -eq $PathPrintSMB}).InstanceId
    if (($DeviceInstanceID -eq $null) -or ($DeviceInstanceID -eq "HTREE\ROOT\0"))
        {
            $TEXTBOX1.SelectedText += "Attention : l'imprimante '$PrinterShareName' n'est pas instalé" 
            $Form.Refresh()
        }
    else
        {
            $TEXTBOX1.SelectedText += "•  L'imprimante '$PrinterShareName' est maintenant diponible pour vos impressions"
            $Form.Refresh()
        }
        
}

#Valeurs d'installation
function installerObject {
    New-Object PSObject -Property @{
        PrinterShareName = ""
        PathPrintSMB = ""
        Printserver = ""
        Domain = ""
    }
}
$Installer = installerObject
[string]$Installer.PrinterShareName = $null
[string]$Installer.PathPrintSMB = $null
[string]$installer.PrintServer = $null
[string]$installer.Domain = "$env:USERDOMAIN"
$Installer.PrinterShareName=$TEXTBOX0.TEXT
$PrinterShareName=$Installer.PrinterShareName
$Domain = $Installer.Domain

#Interface utilisateur
$FORM = New-Object system.Windows.Forms.Form
$form.Size = New-Object System.Drawing.Size(510, 310)
$FORM.OPACITY = 1
$FORM.TEXT = "Service d'impression SMB"
$FORM.FORMBORDERSTYLE = 1
$FORM.STARTPOSITION ="MANUAL"
$FORM.TOPMOST = $TRUE

$RICHTEXTBOX0 = NEW-OBJECT SYSTEM.WINDOWS.FORMS.RICHTEXTBOX
$RICHTEXTBOX0.FONT = NEW-OBJECT SYSTEM.DRAWING.FONT("ARIAL",10,[SYSTEM.DRAWING.FONTSTYLE]::REGULAR)
$RICHTEXTBOX0.TEXT = "Cette interface recherche les droits d'impression de l'utilisateur logué sur un compte AD pour l'imprimante spécifiée. Si l'utilisateur est inclut au groupe d'accès AD d'impression. Le bouton 'Installer' vous permettra d'installer le pilote d'imprimante."
$RICHTEXTBOX0.LOCATION = NEW-OBJECT SYSTEM.DRAWING.SIZE(10,0)
$RICHTEXTBOX0.SIZE = NEW-OBJECT SYSTEM.DRAWING.SIZE(480,70)
$RICHTEXTBOX0.MULTILINE = $TRUE
$RICHTEXTBOX0.SCROLLBARS = 0
$RICHTEXTBOX0.READONLY = $TRUE
$RICHTEXTBOX0.BORDERSTYLE = 0

$TEXTBOX0 = NEW-OBJECT SYSTEM.WINDOWS.FORMS.TEXTBOX
$TEXTBOX0.FONT = NEW-OBJECT SYSTEM.DRAWING.FONT("ARIAL",11,[SYSTEM.DRAWING.FONTSTYLE]::REGULAR)
$TEXTBOX0.TEXT = ""
$TEXTBOX0.SIZE = NEW-OBJECT SYSTEM.DRAWING.SIZE(150,20)
$TEXTBOX0.LOCATION = NEW-OBJECT SYSTEM.DRAWING.POINT(320,70)
$TEXTBOX0.READONLY = $false

$TEXTBOX2 = NEW-OBJECT SYSTEM.WINDOWS.FORMS.TEXTBOX
$TEXTBOX2.FONT = NEW-OBJECT SYSTEM.DRAWING.FONT("ARIAL",11,[SYSTEM.DRAWING.FONTSTYLE]::REGULAR)
$TEXTBOX2.TEXT = "• Saisir le nom de partage de l'imprimante :"
$TEXTBOX2.SIZE = NEW-OBJECT SYSTEM.DRAWING.SIZE(280,20)
$TEXTBOX2.LOCATION = NEW-OBJECT SYSTEM.DRAWING.POINT(20,70)
$TEXTBOX2.ScrollBars = 0
$TEXTBOX2.READONLY = $true 
$TEXTBOX2.BorderStyle = 0

$TextBox1 = New-Object System.Windows.Forms.TextBox
$TextBox1.Location = New-Object System.Drawing.Point(10,140)
$TEXTBOX1.SIZE = NEW-OBJECT SYSTEM.DRAWING.SIZE(480,120)
$TextBox1.text = ""
$TextBox1.Font = 'Microsoft Sans Serif,9'
$TextBox1.Multiline = 1
$TextBox1.ReadOnly = $true
$TextBox1.Scrollbars = "Vertical"
$TextBox1.BorderStyle = 1

$nextButton = New-Object System.Windows.Forms.Button
$nextButton.Text = "Rechercher"
$nextButton.Size = New-Object System.Drawing.Size(100, 25)
$nextButton.Location = New-Object System.Drawing.Point(20, 100)
$nextButton.Enabled=$true
$nextButton.Add_Click({$Installer.PrinterShareName=$TEXTBOX0.Text;next_button})

$instButton = New-Object System.Windows.Forms.Button
$instButton.Text = "Installer"
$instButton.Size = New-Object System.Drawing.Size(100, 25)
$instButton.Location = New-Object System.Drawing.Point(140, 100)
$instButton.Enabled = $false
$instButton.Add_Click({inst_button})

$cancelButton = New-Object System.Windows.Forms.Button
$cancelButton.Text = "Annuler"
$cancelButton.Size = New-Object System.Drawing.Size(100,25)
$cancelButton.Location = New-Object System.Drawing.Point(260,100)
$cancelButton.Enabled=$true
$cancelButton.DialogResult = [System.Windows.Forms.DialogResult]::Cancel

$Form.controls.AddRange((@($RICHTEXTBOX0,$TEXTBOX0,$TEXTBOX1,$TEXTBOX2,$nextButton,$instButton,$cancelButton)))
$form.Add_Shown({$form.Activate()})  
$Form.TopMost = $true
$Form.showdialog()
